/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.codexadrian.tempad.client.widgets.TextButton;
import me.codexadrian.tempad.client.widgets.TimedoorSprite;
import me.codexadrian.tempad.network.messages.AddLocationPacket;
import me.codexadrian.tempad.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;

public class NewLocationScreen
extends Screen {
    private static final ResourceLocation GRID = new ResourceLocation("tempad", "textures/widget/tempad_grid.png");
    private final int color;
    private static final int WIDTH = 480;
    private static final int HEIGHT = 256;
    private final InteractionHand hand;

    public NewLocationScreen(int color, InteractionHand hand) {
        super(Component.m_130674_((String)""));
        this.color = color;
        this.hand = hand;
    }

    protected void m_7856_() {
        super.m_7856_();
        int cornerX = (this.f_96543_ - 480) / 2;
        int cornerY = (this.f_96544_ - 256) / 2;
        TimedoorSprite timeDoorSprite = new TimedoorSprite(cornerX + 64, cornerY + 64, this.color, 128);
        TranslatableComponent addLocationText = new TranslatableComponent("gui.tempad.add_location");
        EditBox textField = new EditBox(this.f_96547_, cornerX + 240, cornerY + 128 - 4, 128, 24, (Component)new TranslatableComponent("gui.tempad.textfield"));
        TextButton addLocation = new TextButton(cornerX + 240, cornerY + 160, 12, (Component)addLocationText, this.color, button -> {
            String nameFieldText = textField.m_94155_();
            if (!nameFieldText.isBlank()) {
                Services.NETWORK.sendToServer(new AddLocationPacket(nameFieldText, this.hand));
                Minecraft.m_91087_().m_91152_(null);
            }
        });
        textField.m_94202_(this.color);
        this.m_142416_(timeDoorSprite);
        this.m_142416_((GuiEventListener)textField);
        this.m_142416_((GuiEventListener)addLocation);
    }

    private void renderOutline(PoseStack poseStack) {
        int lineWidth = 4;
        NewLocationScreen.m_93172_((PoseStack)poseStack, (int)((this.f_96543_ - 480 - lineWidth) / 2), (int)((this.f_96544_ - 256 - lineWidth) / 2), (int)((this.f_96543_ + 480 + lineWidth) / 2), (int)((this.f_96544_ + 256 + lineWidth) / 2), (int)(this.color | 0xFF000000));
    }

    private void renderGridBackground(PoseStack poseStack, float red, float green, float blue) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GRID);
        RenderSystem.m_157429_((float)(red * 0.5f), (float)(green * 0.5f), (float)(blue * 0.5f), (float)1.0f);
        NewLocationScreen.m_93160_((PoseStack)poseStack, (int)((this.f_96543_ - 480) / 2), (int)((this.f_96544_ - 256) / 2), (int)480, (int)256, (float)0.0f, (float)0.0f, (int)480, (int)256, (int)16, (int)16);
    }

    private void renderHeaders(PoseStack matrices) {
        Font font = this.f_96541_.f_91062_;
        int cornerX = (this.f_96543_ - 480) / 2 + 3;
        int cornerY = (this.f_96544_ - 256) / 2 + 3;
        int x = cornerX + 240;
        int y = cornerY + 96;
        matrices.m_85836_();
        matrices.m_85837_((double)x * -0.5, (double)y * -0.5, 0.0);
        matrices.m_85841_(1.5f, 1.5f, 0.0f);
        NewLocationScreen.m_93243_((PoseStack)matrices, (Font)font, (Component)new TextComponent(this.f_96541_.f_91074_.m_142538_().m_123344_()), (int)x, (int)y, (int)this.color);
        matrices.m_85849_();
    }

    public void m_96558_(PoseStack poseStack, int offset) {
        super.m_96558_(poseStack, offset);
        float red = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float green = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(this.color & 0xFF) / 255.0f;
        this.renderOutline(poseStack);
        this.renderGridBackground(poseStack, red, green, blue);
        this.renderHeaders(poseStack);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public boolean m_7043_() {
        return false;
    }
}

